import json
import os
import sys
import requests
import time
import shutil

import yatest.common
from yatest.common import network


def __test_data_path():
    return yatest.common.source_path() + '/passport/infra/recipes/kolmogor/data/'


def __build_path():
    return yatest.common.build_path() + '/passport/infra/daemons/kolmogor/daemon/'


def __get_tvm_api_local_port():
    if os.path.isfile('tvmapi.port'):
        with open('tvmapi.port') as f:
            return int(f.read())


def gen_default_config(pm=network.PortManager()):
    root = {}

    http_port = pm.get_tcp_port(8080)
    repl_port = pm.get_tcp_port(3301)

    tvm_cache_dir = './testing_out_stuff/tvm'
    if os.path.isdir(tvm_cache_dir):
        shutil.rmtree(tvm_cache_dir)
    os.mkdir(tvm_cache_dir)

    root["http_daemon"] = {
        "listen_address": "localhost",
        "ports": [
            {
                "port": http_port,
            },
        ],
    }
    root["component"] = {}
    root["component"]["misc"] = {
        "force_down_file": __build_path() + 'force.down',
    }
    root["component"]["tvm"] = {
        "config": __test_data_path() + 'tvm.conf',
        "cache": "./testing_out_stuff/tvm",
        "local_port": __get_tvm_api_local_port(),
    }
    root["component"]["replication"] = {
        "port": repl_port,
        "dest": [],
        "ping_period_sec": 1,
        "erase_timeout_ms": 3000,
    }
    root["component"]["logger"] = {
        "file": './testing_out_stuff/kolmogor.log',
        "time_format": '_DEFAULT_',
        'level': "ERROR",
    }
    root["component"]["access_log"] = {
        "file": './testing_out_stuff/kolmogor.access.log',
    }
    root["component"]["spaces"] = []
    root["component"]["storage"] = {
        "config_reloading_period_ms": 10,
        "data_directory": __build_path(),
    }

    return root, "http://localhost:%d" % root["http_daemon"]["ports"][0]["port"]


def make_space(name="test_space", num_ttl=3300, splited_count=11, allowed_client_id=None, memory_limit=None):
    space = {}

    space["name"] = name
    space["num_ttl"] = num_ttl
    space["splited_count"] = splited_count
    space["persistency"] = False
    if allowed_client_id is not None:
        space["allowed_client_id"] = [allowed_client_id]
    if memory_limit is not None:
        space["memory_limit"] = int(memory_limit)

    return space


def write_config(path, cfg):
    before = int(os.path.getmtime(path) * 1000) if os.path.exists(path) else 0
    with open(path, 'wb', buffering=0) as f:
        f.write(json.dumps(cfg, indent=4).encode('utf-8'))

    after = int(os.path.getmtime(path) * 1000)
    if after / 1000 == before / 1000:
        # mtime in C++ is time_t - seconds
        time.sleep(1 - (after % 1000) / 1000)
        write_config(path, cfg)


def check_started(kolmo_url):
    i = 0
    while i < 100:
        i = i + 1
        try:
            assert requests.get(kolmo_url + "/ping").status_code == 200
            return
        except Exception as e:
            print(e, file=sys.stderr)
            time.sleep(0.1)

    assert False
