import os

import yatest.common
from yatest.common import network
from library.python.testing.recipe import declare_recipe, set_env
from passport.infra.recipes.common import log, start_daemon, stop_daemon

MYSQL_PORTFILE_NAME = 'mysql.port'
PASSPORT_PORTFILE_NAME = 'passport.port'


def start(argv):
    daemon_port = network.PortManager().get_tcp_port()

    log('Starting passport recipe, port=' + str(daemon_port))

    try:
        with open(MYSQL_PORTFILE_NAME) as f:
            mysql_port = f.read()
    except IOError:
        log('Could not find mysql port file: %s' % MYSQL_PORTFILE_NAME)
        raise RuntimeError('MySQL port is unknown')

    command = [
        yatest.common.build_path('passport/infra/recipes/passport/passport_mock/passport_server'),
        str(daemon_port),
        mysql_port,
    ]

    pid = start_daemon(command, os.environ.copy(), daemon_port, 600).pid
    set_env('RECIPE_PASSPORT_PID', str(pid))
    set_env('RECIPE_PASSPORT_PORT', str(daemon_port))

    with open(PASSPORT_PORTFILE_NAME, 'w') as f:
        f.write(str(daemon_port))


def stop(argv):
    log('Terminating passport recipe')

    # kill passport server
    if 'RECIPE_PASSPORT_PID' not in os.environ:
        log('RECIPE_PASSPORT_PID variable not found in the environment')
        return

    pid = int(os.environ['RECIPE_PASSPORT_PID'])

    stop_daemon(pid)


if __name__ == "__main__":
    declare_recipe(start, stop)
