#!/usr/bin/env python

from http.server import HTTPServer, BaseHTTPRequestHandler
import MySQLdb
import socket
import urllib.parse


class ipv6HTTPServer(HTTPServer):
    address_family = socket.AF_INET6


class RequestHandler(BaseHTTPRequestHandler):
    def response(self, text):
        self.send_response(200)
        self.send_header('Content-type', 'application/json')
        self.end_headers()
        self.wfile.write(text)

    def do_GET(self):
        print('GET:', self.path)

        if self.path.startswith('/ping'):
            self.response("pong".encode('utf-8'))
        elif self.path.startswith('/1/bundle/otp/set_check_time'):
            query = urllib.parse.urlparse(self.path).query
            args = urllib.parse.parse_qs(query)

            if 'X-Ya-Service-Ticket' not in self.headers:
                self.response('{\n  "status": "error",\n  "errors": ["Invalid consumer"]\n}\n'.encode('utf-8'))
                return

            if 'uid' not in args or 'totp_check_time' not in args:
                self.response(
                    '{\n  "status": "error",\n  "errors": ["No uid or totp_check_time argument"]\n}\n'.encode('utf-8')
                )
                return

            uid = args['uid'][0]
            ts = args['totp_check_time'][0]

            if not uid or not ts:
                self.response(
                    '{\n  "status": "error",\n  "errors": ["Uid or totp_check_time empty"]\n}\n'.encode('utf-8')
                )
                return

            with mysql.cursor() as cur:
                cur.execute("UPDATE attributes SET value='%s' WHERE type=106 AND uid=%s;" % (ts, uid))
                cur.fetchall()
            mysql.commit()

            self.response('{\n  "status": "ok"\n}\n'.encode('utf-8'))
        else:
            self.send_error(418, 'Error')


def run_server(port):
    print('Starting "passport" server at port %d' % port)
    server = ipv6HTTPServer(('', port), RequestHandler)
    server.serve_forever()


if __name__ == '__main__':
    from sys import argv, exit

    global mysql

    if len(argv) < 3:
        print('Usage: %s <port> <mysql_port>' % argv[0])
        exit(1)

    mysql = MySQLdb.connect(
        host='127.0.0.1',
        user='root',
        passwd='',
        port=int(argv[2]),
        db="passportdbshard1",
    )

    run_server(int(argv[1]))
