import logging

import sandbox.common.rest as sb_rest

from ci.tasklet.common.proto import service_pb2 as ci
from passport.infra.tasklets.sandbox.proto import (
    set_attribute_tasklet,
)
from tasklet.services.yav.proto import yav_pb2


logger = logging.getLogger(__name__)


class SetSandboxResourceAttributeImpl(set_attribute_tasklet.SetSandboxResourceAttributeBase):
    def run(self):
        progress_msg = ci.TaskletProgress()
        progress_msg.job_instance_id.CopyFrom(self.input.context.job_instance_id)
        progress_msg.module = 'SANDBOX'
        self.ctx.ci.UpdateProgress(progress_msg)

        spec = yav_pb2.YavSecretSpec(uuid=self.input.context.secret_uid, key='sandbox.token')
        oauth_token = self.ctx.yav.get_secret(spec).secret

        resource_id = self.input.resource.resource_id
        if not resource_id:
            raise ValueError('resource_id is not set')

        progress_msg.url = 'https://sandbox.yandex-team.ru/resource/%s/view' % resource_id
        self.ctx.ci.UpdateProgress(progress_msg)

        attributes = self.input.resource.attributes
        if len(attributes) == 0:
            raise ValueError('No attributes in input')

        client = sb_rest.Client() << sb_rest.Client.HEADERS({"Authorization": "OAuth %s" % oauth_token})

        attrs = client.resource[resource_id].attribute.read()
        attrs = {item["name"]: item["value"] for item in attrs}

        for key, value in attributes.items():
            attrs[key] = value

        client.resource[resource_id].update({"attributes": attrs})

        progress_msg.text = 'Атрибуты выставлены'
        progress_msg.status = ci.TaskletProgress.Status.SUCCESSFUL
        self.ctx.ci.UpdateProgress(progress_msg)
