#include <passport/infra/daemons/blackbox/ut/common/common.h>
#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/benchmark/bench.h>

#include <util/generic/singleton.h>

NPassport::NTest::TRequest CreateReq() {
    NPassport::NTest::TRequest req;
    req.Args = {
        {"method", "userinfo"},
        {"userip", "127.0.0.1"},
        {"login", "malice"},
        {"dbfields", "account_info.fio.uid"},
        {"attributes", "27,28"},
    };
    req.InHeaders = {
        {"Host", "blackbox.yandex.net"},
    };
    req.RemoteAddr = "127.0.0.1";
    return req;
}

// NOLINTNEXTLINE(cppcoreguidelines-avoid-non-const-global-variables)
NPassport::NTest::TRequest REQUEST = CreateReq();

Y_CPU_BENCHMARK(userinfo, iface) {
    NPassport::NBb::TBlackbox& bb = *Singleton<NPassport::NBb::TBbHolder>()->Bb;

    for (size_t i = 0; i < iface.Iterations(); ++i) {
        Y_UNUSED(i);

        REQUEST.Response.clear();
        bb.HandleRequest(REQUEST);
        Y_ENSURE(REQUEST.Response == R"(<?xml version="1.0" encoding="UTF-8"?>
<doc>
<uid hosted="0">57155</uid>
<login>malice</login>
<have_password>1</have_password>
<have_hint>0</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<dbfield id="account_info.fio.uid">Bartolome Denis</dbfield>
<attributes>
<attribute type="27">Denis</attribute>
<attribute type="28">Bartolome</attribute>
</attributes>
</doc>
)",
                 REQUEST.Response);
    }
}
