#include <passport/infra/libs/cpp/tvm/signer/signer.h>

#include <library/cpp/tvmauth/ticket_status.h>
#include <library/cpp/tvmauth/deprecated/service_context.h>
#include <library/cpp/tvmauth/src/service_impl.h>
#include <library/cpp/tvmauth/src/utils.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/stream/output.h>
#include <util/string/cast.h>
#include <util/string/split.h>

#include <chrono>
#include <future>

static const TString SECRET = "GRMJrKnj4fOVnvOqe-WyD1";
static const TString TVM_KEYS = "CpgCCpMCCAEQABqIAjCCAQQCggEAcLEXeH67FQESFUn4_7wnX7wN0PUrBoUsm3QQ4W5vC-qz6sXaEjSwnTV8w1o-z6X9KPLlhzMQvuS38NCNfK4uvJ4Zvfp3YsXJ25-rYtbnrYJHNvHohD-kPCCw_yZpMp21JdWigzQGuV7CtrxUhF-NNrsnUaJrE5-OpEWNt4X6nCItKIYeVcSK6XJUbEWbrNCRbvkSc4ak2ymFeMuHYJVjxh4eQbk7_ZPzodP0WvF6eUYrYeb42imVEOR8ofVLQWE5DVnb1z_TqZm4i1XkS7jMwZuBxBRw8DGdYei0lT_sAf7KST2jC0590NySB3vsBgWEVs1OdUUWA6r-Dvx9dsOQtSCVkQYQAAqZAgqUAggCEAAaiQIwggEFAoIBAQDhEBM5-6YsPWfogKtbluJoCX1WV2KdzOaQ0-OlRbBzeCzw-eQKu12c8WakHBbeCMd1I1TU64SDkDorWjXGIa_2xT6N3zzNAE50roTbPCcmeQrps26woTYfYIuqDdoxYKZNr0lvNLLW47vBr7EKqo1S4KSj7aXK_XYeEvUgIgf3nVIcNrio7VTnFmGGVQCepaL1Hi1gN4yIXjVZ06PBPZ-DxSRu6xOGbFrfKMJeMPs7KOyE-26Q3xOXdTIa1X-zYIucTd_bxUCL4BVbwW2AvbbFsaG7ISmVdGu0XUTmhXs1KrEfUVLRJhE4Dx99hAZXm1_HlYMUeJcMQ_oHOhV94ENFIJaRBhACCpYBCpEBCAMQABqGATCBgwKBgF9t2YJGAJkRRFq6fWhi3m1TFW1UOE0f6ZrfYhHAkpqGlKlh0QVfeTNPpeJhi75xXzCe6oReRUm-0DbqDNhTShC7uGUv1INYnRBQWH6E-5Fc5XrbDFSuGQw2EYjNfHy_HefHJXxQKAqPvxBDKMKkHgV58WtM6rC8jRi9sdX_ig2NIJeRBhABCpYBCpEBCAQQABqGATCBgwKBgGB4d6eLGUBv-Q6EPLehC4S-yuE2HB-_rJ7WkeYwyp-xIPolPrd-PQme2utHB4ZgpXHIu_OFksDe_0bPgZniNRSVRbl7W49DgS5Ya3kMfrYB4DnF5Fta5tn1oV6EwxYD4JONpFTenOJALPGTPawxXEfon_peiHOSBuQMu3_Vn-l1IJiRBhADCpcBCpIBCAUQABqHATCBhAKBgQCTJMKIfmfeZpaI7Q9rnsc29gdWawK7TnpVKRHws1iY7EUlYROeVcMdAwEqVM6f8BVCKLGgzQ7Gar_uuxfUGKwqEQzoppDraw4F75J464-7D5f6_oJQuGIBHZxqbMONtLjBCXRUhQW5szBLmTQ_R3qaJb5vf-h0APZfkYhq1cTttSCZkQYQBAqWAQqRAQgLEAAahgEwgYMCgYBvvGVH_M2H8qxxv94yaDYUTWbRnJ1uiIYc59KIQlfFimMPhSS7x2tqUa2-hI55JiII0Xym6GNkwLhyc1xtWChpVuIdSnbvttbrt4weDMLHqTwNOF6qAsVKGKT1Yh8yf-qb-DSmicgvFc74mBQm_6gAY1iQsf33YX8578ClhKBWHSCVkQYQAAqXAQqSAQgMEAAahwEwgYQCgYEAkuzFcd5TJu7lYWYe2hQLFfUWIIj91BvQQLa_Thln4YtGCO8gG1KJqJm-YlmJOWQG0B7H_5RVhxUxV9KpmFnsDVkzUFKOsCBaYGXc12xPVioawUlAwp5qp3QQtZyx_se97YIoLzuLr46UkLcLnkIrp-Jo46QzYi_QHq45WTm8MQ0glpEGEAIKlwEKkgEIDRAAGocBMIGEAoGBAIUzbxOknXf_rNt17_ir8JlWvrtnCWsQd1MAnl5mgArvavDtKeBYHzi5_Ak7DHlLzuA6YE8W175FxLFKpN2hkz-l-M7ltUSd8N1BvJRhK4t6WffWfC_1wPyoAbeSN2Yb1jygtZJQ8wGoXHcJQUXiMit3eFNyylwsJFj1gzAR4JCdIJeRBhABCpYBCpEBCA4QABqGATCBgwKBgFMcbEpl9ukVR6AO_R6sMyiU11I8b8MBSUCEC15iKsrVO8v_m47_TRRjWPYtQ9eZ7o1ocNJHaGUU7qqInFqtFaVnIceP6NmCsXhjs3MLrWPS8IRAy4Zf4FKmGOx3N9O2vemjUygZ9vUiSkULdVrecinRaT8JQ5RG4bUMY04XGIwFIJiRBhADCpYBCpEBCA8QABqGATCBgwKBgGpCkW-NR3li8GlRvqpq2YZGSIgm_PTyDI2Zwfw69grsBmPpVFW48Vw7xoMN35zcrojEpialB_uQzlpLYOvsMl634CRIuj-n1QE3-gaZTTTE8mg-AR4mcxnTKThPnRQpbuOlYAnriwiasWiQEMbGjq_HmWioYYxFo9USlklQn4-9IJmRBhAEEpUBCpIBCAYQABqHATCBhAKBgQCoZkFGm9oLTqjeXZAq6j5S6i7K20V0lNdBBLqfmFBIRuTkYxhs4vUYnWjZrKRAd5bp6_py0csmFmpl_5Yh0b-2pdo_E5PNP7LGRzKyKSiFddyykKKzVOazH8YYldDAfE8Z5HoS9e48an5JsPg0jr-TPu34DnJq3yv2a6dqiKL9zSCakQYSlQEKkgEIEBAAGocBMIGEAoGBALhrihbf3EpjDQS2sCQHazoFgN0nBbE9eesnnFTfzQELXb2gnJU9enmV_aDqaHKjgtLIPpCgn40lHrn5k6mvH5OdedyI6cCzE-N-GFp3nAq0NDJyMe0fhtIRD__CbT0ulcvkeow65ubXWfw6dBC2gR_34rdMe_L_TGRLMWjDULbNIJqRBg";
static const TString PRIV = "MIICVQKBgQC4a4oW39xKYw0EtrAkB2s6BYDdJwWxPXnrJ5xU380BC129oJyVPXp5lf2g6mhyo4LSyD6QoJ-NJR65-ZOprx-TnXnciOnAsxPjfhhad5wKtDQycjHtH4bSEQ__wm09LpXL5HqMOubm11n8OnQQtoEf9-K3THvy_0xkSzFow1C2zQJBANJufhSF9qTZnFlA73M3Mofzhf2AqVqe2L2uN5S9mQyhx6o8zzBm7pGiMiIea9dmOhLyS_BihHkmq4dIw40a25MCQQDgWxGhgsLCiR8R7qd7ixC669xRXyimJz5QYpWKeXhZH4fUjLIbgRRQVhKezMunkAs81yPSVwFyzla8kFTYA2AfAkEAigT7h01LzA_rL9xSyd_I17dSZkVisp7vdyxnrjD1iZqX2IPF9RTrEi7sboCaaP1hS2-G1vs1he3QNdcoTyEGegJAHAtiNDBYWFEj4j3U73FiF117iivlFMTnygxSsU8vCyPw-pGWQ3AiigrCU9mZdPIBZ5rkekrgLlnK15IKmwBsBAJAGk3PwpC-1Jsziygd7mbmUP5wv7AVK1PbF7XG8pezIZQ49UeZ5gzd0jRGREPNeuzHQl5JfgxQjyTVcOkYcaNbcgJATBRJcYoDdz5Y4Wq3Aui8cu8eMFe7iL1Q63twjW47OBjkmLKYYckGryfPHr9IISSazZHAnphq3TkCDZWRYhoMDQJASwsbzFCz7PcNqmQzPBi3foWh7PsYGgpwYINuBS4VnWhIlSaUz3y4HYIyBywVYkIfHfatfRtoT3pNrcosXH0BYg";
static const TString TICKET = "3:serv:CBAQ__________9_IhcIDBAcGgdiYjpzZXNzGghiYjpzZXNzMg:OKjKEbygehEZWH0XEeLzvf0q0aS0VvSk_CKSXGdpqxPbE4RzU70jeM-X9rXVpbYjt76VgBLlBpumJdyiclulfGPDPiL8nwJuu8AnWIR_o-QqyXbsloo2_syE6w2aYw2Yw_5_qjnipYdxGUWegHAGCj3yeMde6O2BmNZ0OCfg6qU";

template <typename Func, typename... Args>
double inline TimeIt(int iterations, Func func, Args... args) {
    std::chrono::high_resolution_clock::time_point t1 = std::chrono::high_resolution_clock::now();
    for (int i = 0; i < iterations; ++i) {
        func(args...);
    }
    std::chrono::high_resolution_clock::time_point t2 = std::chrono::high_resolution_clock::now();
    return std::chrono::duration_cast<std::chrono::microseconds>(t2 - t1).count() / double(iterations);
}

template <typename Func, typename... Args>
double inline RunMultithreaded(int iterations, int threads, Func func, Args... args) {
    std::vector<std::future<double>> vec;
    vec.reserve(threads);
    for (int i = 0; i < threads; ++i) {
        vec.push_back(
            std::async(
                std::launch::async,
                [&iterations, &func, &args...]() {
                    return TimeIt(iterations, func, args...);
                }));
    }
    double total = 0.0;
    for (auto& a : vec) {
        total += a.get();
    }
    return total / double(threads);
}

void inline RunCheck(NTvmAuth::TServiceContext* serviceCtx) {
    serviceCtx->Check(TICKET);
}

void inline RunSign(NTvmAuth::NRw::TRwPrivateKey* priv) {
    const NTvmAuth::TTvmId src = 12;
    const NTvmAuth::TTvmId dst = 28;
    NPassport::NTicketSigner::TServiceSigner b;
    b.SetSides(src, dst);
    b.AddScope("bb:sess");
    b.AddScope("bb:sess2");
    b.SetIssuerUid(123);

    b.SerializeV3(*priv, std::numeric_limits<time_t>::max());
}

double inline RunMultithreadedCheck(int iterations, int threads, NTvmAuth::TServiceContext* serviceCtx) {
    return RunMultithreaded(iterations, threads, RunCheck, serviceCtx);
}

double inline RunMultithreadedSign(int iterations, int threads, NTvmAuth::NRw::TRwPrivateKey* priv) {
    return RunMultithreaded(iterations, threads, RunSign, priv);
}

int main(int argc, const char* argv[]) {
    int threads = 4;
    if (argc > 1) {
        if (TString(argv[1]) == "-j") {
            threads = FromString<int>(TString(argv[2]));
        }
    }

    NTvmAuth::TServiceContext serviceCtx(SECRET, 28, "1:" + TVM_KEYS);
    NTvmAuth::NRw::TRwPrivateKey priv(NTvmAuth::NUtils::Base64url2bin(PRIV), 16);

    Cout << "Single-threaded check: " << RunMultithreadedCheck(1000000, 1, &serviceCtx) << " mks/check" << Endl;
    Cout << "Multi-threaded check: " << RunMultithreadedCheck(1000000, threads, &serviceCtx) << " mks/check" << Endl;
    Cout << "Single-threaded sign: " << RunMultithreadedSign(10000, 1, &priv) << " mks/sign" << Endl;
    Cout << "Multi-threaded sign: " << RunMultithreadedSign(10000, threads, &priv) << " mks/sign" << Endl;
    return 0;
}
