#include "idn.h"

#include <contrib/libs/libidn/lib/idna.h>

namespace Idn1 {
    struct TIdnaPtr {
        TIdnaPtr() = default;
        ~TIdnaPtr() {
            if (Ptr != nullptr) {
                free(Ptr);
            }
        }
        char* Ptr = nullptr;
    };

    TString UtfToPunycode(const TString& buf) {
        TIdnaPtr dst;

        // Try to convert the string
        Idna_rc idnaRet = (Idna_rc)idna_to_ascii_8z(buf.c_str(), &dst.Ptr, 0);
        if (idnaRet != IDNA_SUCCESS) {
            return TString();
        }

        return TString(dst.Ptr);
    }

    TString PunycodeToUtf(const TString& buf) {
        TIdnaPtr dst;

        // Try to convert the string
        Idna_rc idnaRet = (Idna_rc)idna_to_unicode_8z8z(buf.c_str(), &dst.Ptr, 0);
        if (idnaRet != IDNA_SUCCESS) {
            return TString();
        }

        return TString(dst.Ptr);
    }

}
