#include "idn2.h"

#include <contrib/libs/libidn2/include/idn2.h>

#include <util/string/cast.h>

namespace Idn2 {
    struct TIdnaPtr {
        TIdnaPtr() = default;
        ~TIdnaPtr() {
            if (Ptr != nullptr) {
                free(Ptr);
            }
        }
        char* Ptr = nullptr;
    };

    TString ErrStr(int rc) {
        return TString("<err ") + IntToString<10>(rc) + ": " + idn2_strerror(rc) + ">";
    }

    TString UtfToPunycode(const TString& buf) {
        TIdnaPtr dst;

        // Try to convert the string
        idn2_rc idnaRet = (idn2_rc)idn2_to_ascii_8z(buf.c_str(), &dst.Ptr, 0); // normal IDN2 call
        // idn2_rc idnaRet = (idn2_rc)idn2_to_ascii_8z(buf.c_str(), &dst.ptr_, IDN2_NFC_INPUT|IDN2_NONTRANSITIONAL); // IDN2 with compatibility flags as IDN1
        // idn2_rc idnaRet = (idn2_rc)idna_to_ascii_8z(buf.c_str(), &dst.ptr_, 0); // using old IDN1 interface to IDN2
        // if (idnaRet != IDN2_OK) {
        //     idnaRet = (idn2_rc)idn2_to_ascii_8z(buf.c_str(), &dst.ptr_, IDN2_TRANSITIONAL); // IDN1-compatible IDN2 call
        // }

        if (idnaRet != IDN2_OK) {
            return ErrStr(idnaRet);
        }
        // this is for debug purpose here, should be:
        // return TString();

        return TString(dst.Ptr);
    }

    TString PunycodeToUtf(const TString& buf) {
        TIdnaPtr dst;

        // Try to convert the string
        idn2_rc idnaRet = (idn2_rc)idn2_to_unicode_8z8z(buf.c_str(), &dst.Ptr, 0);
        // if (idnaRet != IDN2_OK) {
        //     idnaRet = (idn2_rc)idn2_to_unicode_8z8z(buf.c_str(), &dst.ptr_, IDN2_TRANSITIONAL); // IDN1-compatible IDN2 call
        // }
        if (idnaRet != IDN2_OK) {
            return ErrStr(idnaRet);
        }

        return TString(dst.Ptr);
    }

}
