#include "idn.h"
#include "idn2.h"

#include <util/stream/file.h>
#include <util/stream/output.h>

int main(int argc, char** argv) {
    if (argc < 2) {
        Cout << "Usage: " << argv[0] << " <file_with_domains>" << Endl;
        return 1;
    }

    TString filename(argv[1]);
    TFileInput in(filename);

    TString line;
    while (in.ReadLine(line) > 0) {
        TString utf1 = Idn1::PunycodeToUtf(line);
        TString utf2 = Idn2::PunycodeToUtf(line);

        if (utf1 != utf2) {
            Cerr << "Fail1: punycode->utf mismatch: '" << line << "' converts to '" << utf1 << "' (idn1) and '" << utf2 << "' (idn2)" << Endl;
        }
        TString puny1 = Idn1::UtfToPunycode(utf1);
        TString puny2 = Idn2::UtfToPunycode(utf2);

        if (puny1 != puny2) {
            Cerr << "Fail2: utf->punycode mismatch: '" << line << "' became '" << utf2 << "' which converts back to '" << puny1 << "' (idn1) and '" << puny2 << "' (idn2)" << Endl;
        }

        if (line != puny1) {
            Cerr << "Fail3: punycode->utf->punycode mismatch: '" << line << "' converts back to '" << puny1 << "' (bug in idn1?)" << Endl;
        }
    }

    return 0;
    // TODO: benchmark and compare performance?
}
