//#include <idna.h>
#include <fstream>
#include <iostream>
#include <stdlib.h>
#include <string>

#include <idn2.h>

int main(int argc, char** argv) {
    if (argc < 2) {
        std::cout << "Usage: " << argv[0] << " <file_with_domains>" << std::endl;
        return 1;
    }

    std::ifstream infile(argv[1]);
    std::string line;
    while (std::getline(infile, line)) {
        char* utf = nullptr;
        char* back = nullptr;

        Idna_rc idnaRet = (Idna_rc)idna_to_unicode_8z8z(line.c_str(), &utf, 0);
        if (idnaRet != IDNA_SUCCESS) {
            std::cerr << "Failed to convert domain '" << line << "' from punycode, code " << idnaRet << std::endl;
            continue;
        }

        idnaRet = (Idna_rc)idna_to_ascii_8z(utf, &back, 0);
        if (idnaRet != IDNA_SUCCESS) {
            std::cerr << "Failed to convert domain '" << utf << "' back to utf, original '" << line << "', code " << idnaRet << std::endl;
            continue;
        }

        if (std::string(line) != std::string(back)) {
            std::cerr << "Domain mismatch: '" << line << "' -> '" << utf << "' -> '" << back << "'" << std::endl;
            continue;
        }

        // std::cout<< "Ok: '" << line << "' -> '" << utf << "' -> '" << back << "'" <<std::endl;
        if (utf)
            free(utf);
        if (back)
            free(back);
    }
    return 0;
}
