#!/usr/bin/python
# -*- coding: utf-8 -*-


def test():
    from encodings import idna
    from idna import encode

    NAME = u'βόλος.com'
    print('encodings.idna.ToASCII:\t', idna.ToASCII(NAME))
    print('built-in str encode:\t', NAME.encode('idna'))
    print('idna.encode:\t\t', encode(NAME))


def main(argv):
    import sys

    sys.stdout.reconfigure(encoding='utf-8')
    sys.stderr.reconfigure(encoding='utf-8')

    if len(argv) < 2:
        print("Usage: ", argv[0], " <file_with_domains>")
        test()
        return

    with open(argv[1]) as f:
        for line in f:
            line = line.strip()
            try:
                utf = line.decode('idna')
            except ValueError:
                print("Value error (decode), line=%s" % line)
                continue

            try:
                puny = utf.encode('idna')
            except ValueError:
                print("Value error (encode), line=%s, decoded=%s" % (line, utf))
                continue

            if line != puny:
                print("Fail: mismatch '%s' -> '%s' -> '%s'" % (line, utf, puny))

                # print("Ok '%s' -> '%s' -> '%s'" % (line, utf, puny))


if __name__ == '__main__':
    from sys import argv

    main(argv)
