#include <passport/infra/tools/mauditpipe/src/facade.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/getopt/small/last_getopt.h>

int main(int argc, char** argv) {
    TString configPath;

    try {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption();
        opts.SetFreeArgsNum(0);
        opts.AddLongOption('c', "config", "")
            .StoreResult(&configPath)
            .DefaultValue("/etc/yandex/passport-mauditpipe/config.json");

        NLastGetopt::TOptsParseResult res(&opts, argc, argv);

        NPassport::NMauditpipe::TFacade facade(configPath);
        facade.Run();
    } catch (const std::exception& e) {
        NPassport::TLog::Error() << "main(): got exception, exiting: " << e.what() << Endl;
        return 1;
    }

    return 0;
}
