#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <unordered_map>

namespace NPassport::NMauditpipe {
    class IEncryptor {
    public:
        virtual ~IEncryptor() = default;

        virtual TString Encrypt(TStringBuf str, TInstant now = TInstant::Now()) = 0;
    };

    class TEncryptor: public IEncryptor {
    public:
        TEncryptor(const TString& dir,
                   TDuration rotationPeriod,
                   TInstant now = TInstant::Now());
        TEncryptor(TEncryptor&&) = default;

        TString Encrypt(TStringBuf str, TInstant now) override;

    public:
        const TString& GetKey(ui64 id);

        ui64 GetCurrentKeyId(TInstant now = TInstant::Now()) const;
        static TString LoadKey(const TString& dir, ui64 id);

    private:
        TString Dir_;
        TDuration RotationPeriod_;
        ui64 CurrentKeyId_ = -1;
        TString CurrentKey_;
        TInstant NextPrint_;
    };
}
