#pragma once

#include "encryptor.h"
#include "pipe.h"

#include <passport/infra/libs/cpp/json/config.h>

namespace NPassport::NMauditpipe {
    class TFacade {
    public:
        TFacade(const TString& configPath);

        void Run();

    private:
        static void InitLogs(const NJson::TConfig& cfg, const TString& path);
        static std::unique_ptr<TEncryptor> InitEncryptor(const NJson::TConfig& cfg,
                                                         const TString& path);
        static TPipeSettings InitPipeSettings(const NJson::TConfig& cfg,
                                              const TString& path);

    private:
        std::unique_ptr<TPipe> Pipe_;
        std::unique_ptr<TEncryptor> Encryptor_;
    };
}
