#pragma once

#include "serializer.h"

#include <passport/infra/libs/cpp/json/reader.h>

#include <util/generic/string.h>

namespace NPassport::NMauditpipe {
    class TSkipChecker;

    enum class EInLogType {
        Percona,
        Mcafee,
    };

    EInLogType TypeFromString(const TString& s);

    struct TEntry {
    };

    class IParser {
    public:
        virtual ~IParser() = default;
        virtual void Parse(TStringBuf line) = 0;
        virtual TStringBuf GetQuery() = 0;
        virtual void Build(ISerializer& out) = 0;
    };
    using TParserPtr = std::unique_ptr<IParser>;

    TParserPtr CreateParser(EInLogType type);

    class TBaseParser: public IParser {
    protected:
        static void BuildBase(const rapidjson::Value& data,
                              TStringBuf queryKey,
                              ISerializer& out);

    protected:
        rapidjson::Document Doc_;
    };

    class TPerconaParser: public TBaseParser {
    public:
        static inline const TString QUERYKEY = "sqltext";

        void Parse(TStringBuf line) override;
        TStringBuf GetQuery() override;
        void Build(ISerializer& out) override;

    private:
        const rapidjson::Value* Data_ = nullptr;
    };

    class TMcafeeParser: public TBaseParser {
    public:
        static inline const TString QUERYKEY = "query";

        void Parse(TStringBuf line) override;
        TStringBuf GetQuery() override;
        void Build(ISerializer& out) override;
    };
}
