#pragma once

#include "encryptor.h"
#include "parser.h"
#include "skip_checker.h"

#include <util/datetime/base.h>
#include <util/stream/output.h>

#include <vector>

namespace NPassport::NMauditpipe {
    struct TPipeSettings {
        EInLogType InType = EInLogType::Percona;
        std::vector<TString> MatchSubstrings;
    };

    class TPipe {
    public:
        TPipe(const TPipeSettings& settings, IEncryptor& enc);

        void Stop();

        void Run(IInputStream& in, IOutputStream& out);

        static std::optional<TString> ProcessLine(TStringBuf line,
                                                  EInLogType inType,
                                                  const TSkipChecker& skipChecker,
                                                  IEncryptor& encryptor);

    private:
        EInLogType InType_;
        std::unique_ptr<TSkipChecker> SkipChecker_;
        IEncryptor& Encryptor_;
        std::atomic_bool Exit_ = {false};
    };
}
