#include "serializer.h"

#include "encryptor.h"

#include <regex>

namespace NPassport::NMauditpipe {
    TSerializer::TSerializer(IEncryptor& encryptor, size_t reserve)
        : Encryptor_(encryptor)
    {
        Builder_.Str().reserve(reserve + 256);
        Builder_.Begin("mauditpipe");
    }

    void TSerializer::Add(TStringBuf key, TStringBuf value) {
        Builder_.Add(key, value);
    }

    void TSerializer::AddQuery(TStringBuf key, TStringBuf value) {
        Add(key, Encryptor_.Encrypt(ObfuscateQuery(value)));
    }

    TString TSerializer::Finish() {
        return Builder_.End().Str();
    }

    static const std::regex REGEX(R"(('\w{3})[^']+(\w{3}'))");

    std::string TSerializer::ObfuscateQuery(TStringBuf query) {
        return std::regex_replace(std::string(query), REGEX, "$1...$2");
    }
}
