#pragma once

#include <library/cpp/string_utils/tskv_format/builder.h>

namespace NPassport::NMauditpipe {
    class IEncryptor;

    class ISerializer {
    public:
        virtual ~ISerializer() = default;

        virtual void Add(TStringBuf key, TStringBuf value) = 0;
        virtual void AddQuery(TStringBuf key, TStringBuf value) = 0;
    };

    class TSerializer: public ISerializer {
    public:
        TSerializer(IEncryptor& encryptor, size_t reserve);

        void Add(TStringBuf key, TStringBuf value) override;
        void AddQuery(TStringBuf key, TStringBuf value) override;
        TString Finish();

        static std::string ObfuscateQuery(TStringBuf query);

    private:
        IEncryptor& Encryptor_;
        NTskvFormat::TLogBuilder Builder_;
    };
}
