#include "skip_checker.h"

#include <util/generic/hash_set.h>

namespace NPassport::NMauditpipe {
    TSkipChecker::TSkipChecker(const std::vector<TString>& matchSubstrings)
        : MatchSubstrings_(matchSubstrings)
    {
    }

    static const THashSet<TString> ACCESS_QUERIES = {
        "",
        "Connect",
        "Quit",
    };

    bool TSkipChecker::ShouldSkip(TStringBuf query) const {
        if (ACCESS_QUERIES.contains(query)) {
            return false;
        }

        for (const TString& sub : MatchSubstrings_) {
            if (query.Contains(sub)) {
                return false;
            }
        }

        return true;
    }
}
