#include <passport/infra/tools/mauditpipe/src/encryptor.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NMauditpipe;

Y_UNIT_TEST_SUITE(Encryptor) {
    Y_UNIT_TEST(load) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TEncryptor::LoadKey("./", 100500),
            yexception,
            ".//100500.key");
    }

    Y_UNIT_TEST(getCurrentKeyId) {
        const TString keyBody = "lakjbalkdalkjdsalkjdnbalkjdalksdnaljdsn";

        {
            TFileOutput f("./2643.key");
            f << keyBody;
        }

        TInstant now = TInstant::ParseIso8601("2020-08-27T18:22:32Z");
        UNIT_ASSERT_NO_EXCEPTION(TEncryptor("./", TDuration::Days(7), now));

        TEncryptor enc("./", TDuration::Days(7), now);
        UNIT_ASSERT_VALUES_EQUAL(2643, enc.GetCurrentKeyId(now));
        UNIT_ASSERT_VALUES_EQUAL(keyBody, enc.GetKey(2643));

        UNIT_ASSERT_EXCEPTION_CONTAINS(enc.GetKey(100500),
                                       yexception,
                                       ".//100500.key");
    }
}
