#include <passport/infra/tools/mauditpipe/src/serializer.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/stream/file.h>
#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NMauditpipe;

Y_UNIT_TEST_SUITE(Serializer) {
    Y_UNIT_TEST(obfuscateQuery) {
        struct TCase {
            TString In;
            TString Out;
        };

        std::vector<TCase> cases = {
            {
                .In = R"(Connect)",
                .Out = "Connect",
            },
            {
                .In = R"(select min(id), max(id), count(id) from randoms_signsmth_long)",
                .Out = R"(select min(id), max(id), count(id) from randoms_signsmth_long)",
            },
            {
                .In = R"(INSERT INTO randoms_by (keybody, start, valid) VALUES ('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', 'bbbbbbbbbbbbbbbbbbbbbbbbbb', '2021-05-10 21:10:02'))",
                .Out = R"(INSERT INTO randoms_by (keybody, start, valid) VALUES ('aaa...aaa', 'bbb...bbb', '2021-05-10 21:10:02'))",
            },
        };

        for (const TCase& c : cases) {
            UNIT_ASSERT_VALUES_EQUAL_C(c.Out, TSerializer::ObfuscateQuery(c.In), c.In);
        }
    }
}
