#! /bin/bash

set -e

BRANCH="$1"
PACKAGE="$2"
REPOS="$3"
GPG_KEYID="$4"

ARCADIA_ROOT="$HOME/arcadia"
BUILD_DIR="$HOME/release_build_dir"

rm -rf $BUILD_DIR

arc --update

if [ -f "$ARCADIA_ROOT/.arcadia.root" ]; then
    echo "==== Arcadia is mounted already"
else
    echo "==== Mounting Arcadia..."
    arc mount $ARCADIA_ROOT
    echo "==== Mounting Arcadia...OK"
fi

export PATH="$ARCADIA_ROOT:$PATH"

cd $ARCADIA_ROOT

echo "==== Checkouting branch..."
arc reset --hard HEAD
arc checkout $BRANCH

echo "==== Building package..."
ya package --build=relwithdebinfo -z=none --debian $PACKAGE --key $GPG_KEYID

echo "==== Preparing package..."
mkdir $BUILD_DIR
mv *.tar.gz $BUILD_DIR/
cd $BUILD_DIR
tar -xvzf *.tar.gz
rm -rf *.tar.gz

echo "==== Signing package..."
debsigs -v --sign=origin -k $GPG_KEYID *.deb
echo "==== Updating changes..."
changestool *.changes updatechecksums
echo "==== Signing changes..."
debsign --re-sign -k $GPG_KEYID *.changes

echo "==== Dupload package..."
IFS=';' read -ra REPO <<< "$REPOS"
for REP in "${REPO[@]}"; do
    echo "--- dupload --to $REP"
    dupload --to $REP *.changes
done

echo "===== Done"
