#! /bin/bash

set -e

echo "===== Prepare common packages"
sudo apt install repo-common-stable
sudo apt update -qq || true

UBUNTU_VERSION="$(lsb_release -a 2> /dev/null | grep -Eo '([0-9]+\.[0-9]+)$')"
echo "===== Detected ubuntu: $UBUNTU_VERSION"

if [ $UBUNTU_VERSION \< "20.04" ]; then
    sudo apt -y install python
else
    sudo apt -y install python3 python-is-python3
fi

echo "===== Prepare debian"
sudo apt -y install debhelper dpkg-sig debsigs dupload reprepro

echo "===== Prepare arc"
sudo apt -y install yandex-arc-launcher
systemctl --user enable --now arc-update.timer

if [ ! -f "$HOME/.arc/token" ]; then
    arc token store
fi

echo "===== Prepare GPG key"
# TODO
# yav get secret ...

echo "===== Done"
