#! /bin/bash

set -e

if [ "$EUID" -ne 0 ]
  then echo "Please run as root"
  exit
fi

GPG_KEY_PATH="/var/run/.tmp.key"
cat > $GPG_KEY_PATH << EndOfKey
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=2PrR
-----END PGP PUBLIC KEY BLOCK-----
EndOfKey

KEY_ID="$(gpg --list-packets $GPG_KEY_PATH | awk '/keyid:/{ print $2 }' | head -n 1)"

echo "===== Prepare key dir"
mkdir -p /usr/share/debsig/keyrings/$KEY_ID/

echo "===== Prepare keyring"
gpg --import $GPG_KEY_PATH
gpg --export $KEY_ID > /usr/share/debsig/keyrings/$KEY_ID/debsig.gpg
# gpg --no-default-keyring \
#       --keyring /usr/share/debsig/keyrings/$KEY_ID/debsig.gpg \
#       --import $GPG_KEY_PATH
rm -rf $GPG_KEY_PATH

UBUNTU_VERSION="$(lsb_release -a 2> /dev/null | grep -Eo '([0-9]+\.[0-9]+)$')"
echo "===== Detected ubuntu: $UBUNTU_VERSION"

if [ $UBUNTU_VERSION \< "18.04" ]; then
    SCHEME="http"
else
    SCHEME="https"
fi

echo "===== Prepare policy"
mkdir -p /etc/debsig/policies/$KEY_ID/

cat >/etc/debsig/policies/$KEY_ID/debsig.pol <<EndOfPolicy
<?xml version="1.0"?>
<!DOCTYPE Policy SYSTEM "$SCHEME://www.debian.org/debsig/1.0/policy.dtd">
<Policy xmlns="$SCHEME://www.debian.org/debsig/1.0/">

  <Origin Name="Bot" id="$KEY_ID"  Description="Signed by bot"/>

  <Selection>
    <Required Type="origin" File="debsig.gpg" id="$KEY_ID"/>
  </Selection>

   <Verification MinOptional="0">
    <Required Type="origin" File="debsig.gpg" id="$KEY_ID"/>
   </Verification>
</Policy>
EndOfPolicy

echo "===== Done"
