import json
import startrek_client
import sys


def get_token():
    with open('./token') as f:
        return f.read()


ENABLE = False
LIMIT = 1
CLIENT = startrek_client.Startrek(useragent='kek', base_url='https://st-api.yandex-team.ru/', token=get_token())
MEMBERS = [
    'abc_admins',
    'abc_managers',
    'c_admins',
    'net_owners',
    'fw_owners',
    'abc_owners',
    'staff_owners',
    'host_owners',
]
SKIP_KEY_LEN = len('https://st-api.yandex-team.ru/v2/issues/')

IDX = 0


def process_file(filename):
    global IDX

    with open(filename) as f:
        tasks = json.load(f)

    for name, task in tasks.items():
        IDX += 1
        if IDX > LIMIT:
            print(" ==== Done")
            sys.exit(0)

        try:
            users = []
            for m in MEMBERS:
                if m in task:
                    users = users + [a for a in task[m] if not a.startswith('robot-')]

            if len(users) > 3:
                users = users[:3]

            if not ENABLE:
                users = None

            issue = CLIENT.issues.create(
                queue='PASSPORTGRANTS',
                type={'name': 'Task'},
                components=['#GrantsReview'],
                summary=task['summary'],
                description=task['text'],
                followers=users,
                deadline=task['deadline'],
                #                       tags=[],
                #                       assignee='',
            )
            print('https://st.yandex-team.ru/%s. %s -> %s' % (issue.self[SKIP_KEY_LEN:], name, users))

        except Exception as e:
            print('%s : %s' % (name, e))


if __name__ == '__main__':
    for f in sys.argv[1:]:
        print(" ==== %s ====" % f)
        process_file(f)
