#! /bin/bash

set -e

# fetch raw stats from *.tar.gz
for f in $(find . -type f -name "*gz"); do gunzip -k $f; rm $f; done

TMPDIR="./tmp"
OUTDIR="./output"

# cleanup
rm -rf $TMPDIR $OUTDIR parseenv
mkdir $TMPDIR $OUTDIR

# prepare list of unused consumers
GRANTS="$TMPDIR/consumer_grants.production.json"
curl -s "https://raw.github.yandex-team.ru/passport/passport-grants/master/grants/consumer_grants.production.json" -o $GRANTS

# prepare virtualenv
#virtualenv -p python3 parseenv
#. parseenv/bin/activate
#pip3 install requests
#pip3 install -i https://pypi.yandex-team.ru/simple/ startrek_client

python3 prepare.py $OUTDIR *txt > $TMPDIR/prepare.out 2> $TMPDIR/prepare.err
