#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('development', 'sas'),
    'testing': ('testing', 'myt'),
    'stable': ('production', None),
}


def build_env(env):
    ctype, geo = _ENV[env]

    result = {
        'owners': ['cerevra'],
        'name': env,
        'title': env,
        'type': 'dummy',
        'children': [
            {
                'name': 'default',
                'title': 'default',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_default',
                'substitutions': {
                    '__itype': 'passporthistorydbapi2',
                    '__prefix': 'historydbapi2',
                    '__geo': geo,
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.historydbapi2',
                    '__commonprj': 'passport.kvs.api',
                },
            },
            {
                'name': 'specific',
                'title': 'specific',
                'type': 'template_panel',
                'item_id': 'passport_historydbapi2_specific',
                'substitutions': {
                    '__geo': geo,
                    '__ctype': ctype,
                },
            },
        ],
    }

    return result


def main():
    result = {}
    result['path'] = '/passport/historydbapi2'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'historydbapi2',
        'title': 'historydbapi2',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_historydbapi2.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
