#!/usr/bin/env python3
import json
import sys


_ENV = {
    'stable': ('production', None),
    'prestable': ('production', 'sas'),
    'yateam_stable': ('production.intranet', None),
    'yateam_prestable': ('production.intranet', 'sas'),
    'testing': ('testing', None),
    'dev': ('dev', None),
}


def add_panels(env):
    ctype, geo = _ENV[env]

    return [
        {
            'name': 'default',
            'title': 'kolmogor.default',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_default',
            'substitutions': {
                '__itype': 'passportkolmogor',
                '__prefix': 'kolmogor',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.badauthdb',
            },
        },
        {
            'name': 'spaces',
            'title': 'kolmogor.spaces',
            'type': 'template_panel',
            'item_id': 'passport_kolmogor_spaces',
            'substitutions': {
                '__itype': 'passportkolmogor',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.badauthdb',
            },
        },
        {
            'name': 'specific',
            'title': 'kolmogor.specific',
            'type': 'template_panel',
            'item_id': 'passport_kolmogor_specific',
            'substitutions': {
                '__itype': 'passportkolmogor',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.badauthdb',
            },
        },
        {
            'name': 'replication',
            'title': 'kolmogor.replication',
            'type': 'template_panel',
            'item_id': 'passport_kolmogor_replication',
            'substitutions': {
                '__itype': 'passportkolmogor',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.badauthdb',
            },
        },
    ]


def build_env(env):
    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
        'children': [],
    }
    result['children'] += add_panels(env)

    return result


def main():
    result = {}
    result['path'] = '/passport/kolmogor'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'kolmogor',
        'title': 'kolmogor',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('prestable'))
    result['tree']['children'].append(build_env('yateam_stable'))
    result['tree']['children'].append(build_env('yateam_prestable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_kolmogor.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
