#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('dev', 'CON'),
    'testing': ('testing', 'CON'),
    'prestable': ('production', 'lbcbck-s1.passport.yandex.net'),
    'stable': ('production', 'CON'),
}


def build_env(env):
    ctype, host = _ENV[env]

    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'template_panel',
        'item_id': 'passport_lbcbck',
        'substitutions': {
            'ctype': ctype,
            'host': host,
        },
    }

    return result


def build_alerts():
    result = {
        'name': 'alerts',
        'title': 'alerts (production)',
        'type': 'panel',
        'item_id': 'cerevra._3RAbnH',
    }

    return result


def main():
    result = {}
    result['path'] = '/passport/lbcbck'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'lbcbck',
        'title': 'lbcbck',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('prestable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))
    result['tree']['children'].append(build_alerts())

    with open('passport_lbcbck.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
