#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('development', 'sas'),
    'testing': ('testing', 'myt'),
    'stable': ('production', 'sas, man, iva'),
}


def build_env(env):
    ctype, geo = _ENV[env]

    result = {
        'owners': ['cerevra'],
        'name': env,
        'title': env,
        'type': 'dummy',
        'children': [],
    }

    children = [
        {
            'name': 'lbc',
            'title': 'lbc',
            'type': 'template_panel',
            'item_id': 'passport_lbchdb',
            'substitutions': {
                'ctype': ctype,
                'geo': geo,
            },
        }
    ]

    for geo_ in geo.split(', '):
        children += [
            {
                'name': 'kolmogor_%s' % geo_,
                'title': 'kolmogor (%s)' % geo_,
                'type': 'dummy',
                'children': [
                    {
                        'name': 'kolmog_default',
                        'title': 'kolmogor.default',
                        'type': 'template_panel',
                        'item_id': 'passport_common_daemon_default',
                        'substitutions': {
                            '__itype': 'passportlbchdbkolmogor',
                            '__prefix': 'kolmogor',
                            '__geo': geo_,
                            '__ctype': ctype,
                            '__tier': 'none',
                            '__prj': 'passport.lbchdb.kolmogor',
                        },
                    },
                    {
                        'name': 'spaces',
                        'title': 'kolmogor.spaces',
                        'type': 'template_panel',
                        'item_id': 'passport_kolmogor_spaces',
                        'substitutions': {
                            '__itype': 'passportlbchdbkolmogor',
                            '__geo': geo_,
                            '__ctype': ctype,
                            '__tier': 'none',
                            '__prj': 'passport.lbchdb.kolmogor',
                        },
                    },
                    {
                        'name': 'specific',
                        'title': 'kolmogor.specific',
                        'type': 'template_panel',
                        'item_id': 'passport_kolmogor_specific',
                        'substitutions': {
                            '__itype': 'passportlbchdbkolmogor',
                            '__geo': geo_,
                            '__ctype': ctype,
                            '__tier': 'none',
                            '__prj': 'passport.lbchdb.kolmogor',
                        },
                    },
                    {
                        'name': 'replication',
                        'title': 'kolmogor.replication',
                        'type': 'template_panel',
                        'item_id': 'passport_kolmogor_replication',
                        'substitutions': {
                            '__itype': 'passportlbchdbkolmogor',
                            '__geo': geo_,
                            '__ctype': ctype,
                            '__tier': 'none',
                            '__prj': 'passport.lbchdb.kolmogor',
                        },
                    },
                ],
            }
        ]

        children += [
            {
                'name': 'dbpool_%s' % geo_,
                'title': 'dbpool (%s)' % geo_,
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_dbpool',
                'substitutions': {
                    '__itype': 'passportlbchdb2',
                    '__prefix': 'lbchdb',
                    '__geo': geo_,
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.lbchdb',
                },
            },
        ]

    result['children'] = children

    return result


def main():
    result = {}
    result['path'] = '/passport/lbchdb'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'lbchdb',
        'title': 'lbchdb',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_lbchdb.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
