#!/usr/bin/env python3
import json
import sys

_ENVS = {
    'stable': {
        'ctype': 'production,production.intranet',
    },
    'testing': {
        'ctype': 'testing,testing.intranet',
    },
}


def build_env(env):
    return [
        {
            'name': env,
            'title': env,
            'type': 'template_panel',
            'item_id': 'passport_logstoreagent',
            'substitutions': _ENVS[env],
        },
        {
            'name': env + '_dbpool',
            'title': env + '_dbpool',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_dbpool',
            'substitutions': {
                '__itype': 'passportlogstoreagent',
                '__prefix': 'logstoreagent',
                '__ctype': _ENVS[env]['ctype'],
                '__tier': 'none',
                '__prj': 'passport.logstoreagent',
            },
        },
    ]


def main():
    result = {
        'path': '/passport/logstoreagent',
        'tree': {
            'name': 'logstoreagent',
            'title': 'logstoreagent',
            'type': 'dummy',
            'children': [],
        },
    }

    result['tree']['children'] = build_env('stable') + build_env('testing')

    with open('passport_logstoreagent.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
