#!/usr/bin/env python3
import json
import sys


def build_default_panel(host):
    name = host.split('.')[0]

    return {
        'name': 'default_' + name,
        'title': 'default (%s)' % name,
        'type': 'template_panel',
        'item_id': 'passport_common_daemon_default',
        'substitutions': {
            '__host': host,
            '__itype': 'passportlogstoreapi2',
            '__prefix': 'logstoreapi',
            '__ctype': 'production',
            '__tier': 'none',
            '__prj': 'passport.logstoreapi',
        },
    }


def build():
    return [
        {
            'name': 'common',
            'title': 'common',
            'type': 'template_panel',
            'item_id': 'passport_logstoreapi',
        },
        build_default_panel('logstore-f1.passport.yandex.net'),
        build_default_panel('kvs-logstore-f1.passport.yandex.net'),
        build_default_panel('mon-logstore-f1.passport.yandex.net'),
        build_default_panel('logstore-s1.passport.yandex.net'),
    ]


def main():
    result = {
        'path': '/passport/logstoreapi',
        'tree': {
            'name': 'logstoreapi',
            'title': 'logstoreapi',
            'type': 'dummy',
            'children': [],
        },
    }

    result['tree']['children'] = build()

    with open('passport_logstoreapi.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
