#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('development', None),
    'testing': ('testing', None),
    'stable': ('production', None),
}


def build_env(env):
    ctype, geo = _ENV[env]

    return {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
        'children': [
            {
                'name': 'lbc',
                'title': 'lbc',
                'type': 'template_panel',
                'item_id': 'passport_lbcpharma',
                'substitutions': {
                    'ctype': ctype,
                    'host': 'CON',
                },
            },
            {
                'name': 'lbc_dbpool',
                'title': 'lbc_dbpool',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_dbpool',
                'substitutions': {
                    '__itype': 'passportlbcpharma',
                    '__prefix': 'lbcpharma',
                    '__geo': geo,
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.lbcpharma',
                },
            },
            {
                'name': 'api',
                'title': 'api',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_default',
                'substitutions': {
                    '__itype': 'passportpharmaapi',
                    '__prefix': 'pharmaapi',
                    '__geo': geo,
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.pharmaapi',
                },
            },
            {
                'name': 'api_dbpool',
                'title': 'api_dbpool',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_dbpool',
                'substitutions': {
                    '__itype': 'passportpharmaapi',
                    '__prefix': 'pharmaapi',
                    '__geo': geo,
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.pharmaapi',
                },
            },
        ],
    }


def main():
    result = {}
    result['path'] = '/passport/pharma'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'pharma',
        'title': 'pharma',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_pharma.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
