#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('development'),
    'testing': ('testing'),
    'stable': ('production'),
}


def build_env(env):
    ctype = _ENV[env]

    result = {
        'owners': ['cerevra', 'avmm'],
        'name': env,
        'title': env,
        'type': 'dummy',
        'children': [
            {
                'name': 'default',
                'title': 'default',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_default',
                'substitutions': {
                    '__itype': 'passportpush_subscription',
                    '__prefix': 'push_subscription',
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.push_subscription',
                },
            },
            {
                'name': 'specific',
                'title': 'specific',
                'type': 'template_panel',
                'item_id': 'passport_push_subscription_specific',
                'substitutions': {
                    '__ctype': ctype,
                },
            },
        ],
    }

    return result


def main():
    result = {}
    result['path'] = '/passport/push_subscription'
    result['tree'] = {
        'owners': ['cerevra', 'avmm'],
        'name': 'push_subscription',
        'title': 'push_subscription',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_push_subscription.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
