#!/usr/bin/env python3
import json
import sys

SEZAM_ENV = {
    'dev': ('dev', 'sas'),
    'testing': ('testing', 'sas, man'),
    'rc': ('rc', 'sas, man, myt'),
    'prestable': ('production', 'sas'),
    'stable': ('production', None),
    'yateam_testing': ('testing', 'sas, man'),
    'yateam_prestable': ('production', 'sas'),
    'yateam_stable': ('production', None),
}


def add_default_panels(env, subset, project):
    ctype, geo = SEZAM_ENV[env]

    if subset == 'yateam':
        ctype += '.intranet'

    return [
        {
            'name': 'default',
            'title': 'default',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_default',
            'substitutions': {
                '__itype': 'passport' + project,
                '__prefix': project,
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.' + project,
            },
        },
        {
            'name': 'health',
            'title': 'health',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_health',
            'substitutions': {
                '__itype': 'passport' + project,
                '__prefix': project,
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.' + project,
            },
        },
        {
            'name': 'dbpools',
            'title': 'dbpools',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_dbpool',
            'substitutions': {
                '__itype': 'passport' + project,
                '__prefix': project,
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.' + project,
            },
        },
        {
            'name': 'workpool',
            'title': 'workpool',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_workpool',
            'substitutions': {
                '__itype': 'passport' + project,
                '__prefix': project,
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.' + project,
            },
        },
    ]


def add_dbpool_ext(env, subset, project, subset_params, db, geo, daemon=''):
    ctype, _geo = SEZAM_ENV[env]
    tier, description, path_suffix = subset_params
    if len(daemon) == 0:
        daemon = project

    if subset == 'yateam':
        ctype += '.intranet'

    return {
        'name': db + path_suffix,
        'title': db,
        'type': 'template_panel',
        'item_id': 'passport_common_daemon_dbpool_ext',
        'substitutions': {
            '__itype': 'passport' + project,
            '__prefix': project,
            '__geo': geo,
            '__ctype': ctype,
            '__tier': 'none',
            '__prj': 'passport.' + project,
            '__db': db,
        },
    }


def add_sezamapi_panels(env, subset):
    ctype, geo = SEZAM_ENV[env]

    return add_default_panels(env, subset, 'sezamapi') + [
        {
            'name': 'specific',
            'title': 'specific',
            'type': 'template_panel',
            'item_id': 'passport_sezam_sezamapi_specific',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
            },
        },
    ]


def build_sezamapi(env):
    result = {
        'name': 'sezamapi',
        'title': 'sezamapi',
        'type': 'dummy',
        'children': [],
    }

    return result


def build_env(env):
    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
        'children': [],
    }

    if env == 'dev':
        result['children'] += add_sezamapi_panels(env, 'dev')
    elif env == 'testing':
        result['children'] += add_sezamapi_panels(env, 'testing')
    elif env == 'yateam_testing':
        result['children'] += add_sezamapi_panels(env, 'yateam')
    elif env == 'yateam_prestable':
        result['children'] += add_sezamapi_panels(env, 'yateam')
    elif env == 'yateam_stable':
        result['children'] += add_sezamapi_panels(env, 'yateam')
    elif env == 'mimino':
        return None
    else:
        result['children'] += add_sezamapi_panels(env, 'common')

    return result


def build_simple_alerts():
    return {
        'name': 'simple_alerts',
        'title': 'simple_alerts',
        'type': 'template_panel',
        'item_id': 'passport_simple_alerts',
    }


def main():
    result = {}
    result['path'] = '/passport/sezamapi'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'sezamapi',
        'title': 'sezamapi',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('prestable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))
    result['tree']['children'].append(build_env('rc'))
    result['tree']['children'].append(build_env('yateam_testing'))
    result['tree']['children'].append(build_env('yateam_prestable'))
    result['tree']['children'].append(build_env('yateam_stable'))
    result['tree']['children'].append(build_simple_alerts())

    with open('passport_sezamapi.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
