#!/usr/bin/env python3
import json


_ENV = {
    'stable': ('production.intranet', None, 'passport.tirole'),
    'testing': ('testing.intranet', None, 'passport.tvm'),
    'dev': ('development', None, 'passport.tvm'),
}


def add_panels(env):
    ctype, geo, common = _ENV[env]

    return [
        {
            'name': 'default',
            'title': 'tirole.default',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_default',
            'substitutions': {
                '__itype': 'passporttirole',
                '__prefix': 'tirole',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.tirole',
                '__commonprj': common,
            },
        },
        {
            'name': 'specific',
            'title': 'tirole.specific',
            'type': 'template_panel',
            'item_id': 'passport_tirole_specific',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
            },
        },
        {
            'name': 'consumers',
            'title': 'tirole.consumers',
            'type': 'template_panel',
            'item_id': 'passport_tirole_consumers',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
            },
        },
    ]


def build_env(env):
    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
        'children': [],
    }
    result['children'] += add_panels(env)

    return result


def main():
    result = {}
    result['path'] = '/passport/tirole'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'tirole',
        'title': 'tirole',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_tirole.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
