#!/usr/bin/env python3
import json
import sys


TVM_ENV = {
    'dev': ('dev', 'sas'),
    'prestable': ('production.intranet', 'sas'),
    'stable': ('production.intranet', 'sas, man, vla, myt, iva'),
}


def add_tvm_panels(env):
    ctype, geo = TVM_ENV[env]

    return [
        {
            'name': 'default',
            'title': 'tvm.default',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_default',
            'substitutions': {
                '__itype': 'passporttvmapi',
                '__prefix': 'tvm',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.tvm',
            },
        },
        {
            'name': 'health',
            'title': 'tvm.health',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_health',
            'substitutions': {
                '__itype': 'passporttvmapi',
                '__prefix': 'tvm',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.tvm',
            },
        },
        {
            'name': 'dbpools',
            'title': 'tvm.dbpools',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_dbpool',
            'substitutions': {
                '__itype': 'passporttvmapi',
                '__prefix': 'tvm',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.tvm',
            },
        },
        {
            'name': 'specific',
            'title': 'tvm.specific',
            'type': 'template_panel',
            'item_id': 'passport_tvm_specific',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
            },
        },
        {
            'name': 'consumers',
            'title': 'tvm.consumers',
            'type': 'template_panel',
            'item_id': 'passport_tvm_consumers',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
            },
        },
    ]


def add_host_panels(env):
    ctype, geo = TVM_ENV[env]

    return [
        {
            'name': 'hostmetrics',
            'title': 'host.metrics',
            'type': 'template_panel',
            'item_id': 'passport_host_metrics',
            'substitutions': {
                '__itype': 'common',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.tvm',
            },
        },
    ]


def build_tvm(env):
    return add_tvm_panels(env)  # + add_host_panels(env)


def build_env(env):
    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
        'children': [],
    }
    result['children'] += build_tvm(env)

    return result


def main():
    result = {}
    result['path'] = '/passport/tvm/tvm-api'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'tvm-api',
        'title': 'tvm-api',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('prestable'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_tvm.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
