#!/usr/bin/env python3
import json
import sys


_ENV = {
    'dev': ('development'),
    'testing': ('testing'),
    'stable': ('production'),
}


def build_env(env):
    ctype = _ENV[env]

    result = {
        'owners': ['cerevra'],
        'name': env,
        'title': env,
        'type': 'dummy',
        'children': [
            {
                'name': 'default',
                'title': 'default',
                'type': 'template_panel',
                'item_id': 'passport_common_daemon_default',
                'substitutions': {
                    '__itype': 'passportyasms_internal',
                    '__prefix': 'yasms_internal',
                    '__ctype': ctype,
                    '__tier': 'none',
                    '__prj': 'passport.yasms_internal',
                },
            },
            {
                'name': 'specific',
                'title': 'specific',
                'type': 'template_panel',
                'item_id': 'passport_yasms_internal_specific',
                'substitutions': {
                    '__ctype': ctype,
                },
            },
        ],
    }

    return result


def main():
    result = {}
    result['path'] = '/passport/yasms_internal'
    result['tree'] = {
        'owners': ['cerevra'],
        'name': 'yasms_internal',
        'title': 'yasms_internal',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_env('stable'))
    result['tree']['children'].append(build_env('testing'))
    result['tree']['children'].append(build_env('dev'))

    with open('passport_yasms_internal.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
