#!/usr/bin/env python3
import json
import sys


_ENV = {
    'testing': ('testing', 'myt,man,sas,iva,vla'),
    'prestable': ('production', 'vla'),
    'stable': ('production', None),
}


def build_env(env):
    ctype, geo = _ENV[env]

    result = {
        'name': env,
        'title': env if env != 'stable' else 'stable+prestable',
        'type': 'dummy',
    }

    result['children'] = [
        {
            'name': 'ysadefault',
            'title': 'ysa.default',
            'type': 'template_panel',
            'item_id': 'passport_common_daemon_default',
            'substitutions': {
                '__itype': 'passportysa',
                '__prefix': 'ysa',
                '__geo': geo,
                '__ctype': ctype,
                '__tier': 'none',
                '__prj': 'passport.ysa',
            },
        },
        {
            'name': 'ysaspecific',
            'title': 'ysa.specific',
            'type': 'template_panel',
            'item_id': 'passport_ysa',
            'substitutions': {
                '__geo': geo,
                '__ctype': ctype,
            },
        },
    ]

    return result


def build_timing(name, panel):
    return {
        'name': name,
        'title': name,
        'type': 'panel',
        'item_id': panel,
    }


def build_stable():
    result = build_env('stable')
    result['children'] += [
        {
            'name': 'api-net-cpu',
            'title': 'api net & cpu',
            'type': 'panel',
            'item_id': '_PQ4BGJ',
        },
        {
            'name': 'storage-net-cpu',
            'title': 'storage net & cpu',
            'type': 'panel',
            'item_id': '_3ETKvt',
        },
        {
            'name': 'timings',
            'title': 'timings',
            'type': 'dummy',
            'children': [
                build_timing('captcha-static', '_MhLvIV'),
                build_timing('market-static', '_PJDWr_'),
                build_timing('nginx-static', '_MhLvIV'),
                build_timing('ping-static', '_C2SfhQ'),
                build_timing('pssp-domik-static', '_XKghbi'),
                build_timing('pssp-phone-static', '_Ye08u2'),
                build_timing('pssp-reg-static', '_eXqsi8'),
                build_timing('rsya-static', '_XW4hoy'),
                build_timing('serp-static', '_WBgWMg'),
                build_timing('toloka-static', '_wuq44a'),
            ],
        },
        {
            'name': 'alerts',
            'title': 'alerts',
            'type': 'panel',
            'item_id': '_cuJ4q_',
        },
    ]

    return result


def main():
    result = {}
    result['path'] = '/passport/ysa'
    result['tree'] = {
        'owners': ['abbat', 'avmm', 'cerevra', 'dyor'],
        'name': 'ysa',
        'title': 'ysa',
        'type': 'dummy',
        'children': [],
    }
    result['tree']['children'].append(build_stable())
    result['tree']['children'].append(build_env('prestable'))
    result['tree']['children'].append(build_env('testing'))

    with open('passport_ysa.json', 'wt') as f:
        f.write(json.dumps(result, indent=4))
        f.write('\n')


if __name__ == '__main__':
    main()
