#!/usr/bin/env python3
import json
import sys

import requests


def do_push(files):
    for f in files:
        with open(f) as fin:
            body = fin.read()

        body = json.dumps(json.loads(body))
        r = requests.post('https://yasm.yandex-team.ru/srvambry/menutree/replace', data=body)
        if r.status_code != 200:
            print("%s: failed" % f)
            print(r.text)
            sys.exit(1)

        print("%s: success!" % f)


if __name__ == '__main__':
    if len(sys.argv) < 2:
        print("required list of files to push")
        sys.exit(1)

    do_push(sys.argv[1:])
