#!/usr/bin/env bash

if [ "$#" == "0" ]; then
    echo "USAGE:"
    echo "$0 template1.j2 .. templateN.j2"
    echo
    echo "NOTE: Templates should be created before"
    echo
    exit 1
fi

while (( "$#" )); do
    tepmlate_name=${1%%.*}
    file_ext=${1##*.}

    if [[ "${file_ext}" != "j2" ]]; then
        echo "SKIP ${1}: Not \"j2\"-file"
        shift
        continue
    fi

    echo -e "Uploading ${1} to ${tepmlate_name}"

    CURL_STDOUT_FILE=$(mktemp)
    CURL_STDERR_FILE=$(mktemp)
    CURL_OUT_FILE=$(mktemp)
    curl -sS -w "%{http_code}" --data-binary @${1} "https://yasm.yandex-team.ru/srvambry/tmpl/panels/update/content?key=${tepmlate_name}" -o ${CURL_OUT_FILE} >${CURL_STDOUT_FILE} 2>${CURL_STDERR_FILE}
    if [[ $? -gt 0 ]]; then
        echo "Error: $(cat ${CURL_STDERR_FILE})"
    elif [[ $(cat ${CURL_STDOUT_FILE}) -ne 200 ]]; then
        echo "Error: $(cat ${CURL_STDOUT_FILE}): \"$(cat ${CURL_OUT_FILE})\""
    else
        echo "Done"
    fi
    echo
    rm -f ${CURL_STDOUT_FILE} ${CURL_STDERR_FILE} ${CURL_OUT_FILE}

    shift
done
