#include "aliases.h"

#include <library/cpp/config/config.h>
#include <library/cpp/config/ini.h>

#include <util/folder/dirut.h>
#include <util/stream/file.h>
#include <util/stream/output.h>
#include <util/string/cast.h>
#include <util/string/type.h>
#include <util/system/fs.h>

namespace NPassport::NTvmknife {
    static const TString ALIASES_FILENAME = "aliases";

    TAliases::TAliases() {
        ReadFromFile(GetHomeDir() + "/.tvmknife/" + ALIASES_FILENAME);
    }

    void TAliases::ReadFromFile(TString filename) {
        ui32 tvm_id;
        Aliases_.clear();

        if (!NFs::Exists(filename)) {
            return;
        }

        TFileInput aliasesIni(filename);
        auto config = NConfig::ParseIni(aliasesIni);
        const auto& sections = config.Get<NConfig::TDict>();
        for (auto&& [section, aliases] : sections) {
            Aliases_[section] = TMap<TString, ui32>();
            auto sectionAliases = aliases.Get<NConfig::TDict>();
            for (auto&& [alias, configValue] : sectionAliases) {
                TString value = configValue.As<TString>();

                if (!TryIntFromString<10>(value, tvm_id)) {
                    Cerr << "Ignoring bad alias value " << value << " for key " << alias << " in section " << section << Endl;
                    continue;
                }

                Aliases_[section][alias] = tvm_id;
            }
        }
    }

    TMaybe<ui32> TAliases::ResolveAlias(TString section, TString alias) {
        try {
            return Aliases_.at(section).at(alias);
        } catch (std::out_of_range) {
            return TMaybe<ui32>();
        }
    }
}
