#include "blackbox_client.h"

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/http/simple/http_client.h>
#include <library/cpp/string_utils/quote/quote.h>
#include <library/cpp/tvmknife/simple_tvm_client.h>

#include <util/stream/str.h>

template <>
void Out<TSimpleHttpClient::THeaders>(IOutputStream& o, const TSimpleHttpClient::THeaders& value) {
    for (const auto& pair : value) {
        o << pair.first << ": " << pair.second << Endl;
    }
}

namespace {
    class TClientUtils: NTvmknife::TSimpleTvmClient {
    public:
        using TSimpleTvmClient::PrettifyJson;
    };
}

namespace NPassport::NTvmknife {
    TBbClient::TRequest TBbClient::CreateDebugUserTicketRequest(const TDebugUTParams& params) {
        TStringStream request;
        request << "/blackbox"
                << "?method=get_debug_user_ticket"
                << "&format=json";

        if (params.AddScopeSessionid) {
            request << "&add_scope_sessionid=yes";
        }
        if (params.AddScopeSessguard) {
            request << "&add_scope_sessguard=yes";
        }

        return {request.Str(), "oauth_token=" + CGIEscapeRet(params.OauthToken)};
    }

    TString TBbClient::DoRequest(const TString& blackbox,
                                 const TRequest& request,
                                 TStringBuf serviceTicket) {
        const TSimpleHttpClient::THeaders headers{
            {"X-Ya-Service-Ticket", TString(serviceTicket)},
        };

        TString out;
        try {
            TStringOutput s(out);
            const TSimpleHttpClient::TOptions opts(blackbox);
            TSimpleHttpClient client(opts);
            client.DoPost(request.GetParams, request.Body, &s, headers);

            Y_ENSURE(out.Contains(R"("user_ticket")"),
                     "missing 'user_ticket' in response");
        } catch (const std::exception& e) {
            ythrow yexception() << "Failed to check credential:" << Endl
                                << e.what() << Endl << Endl
                                << blackbox << request.GetParams << Endl
                                << headers
                                << TClientUtils::PrettifyJson(out) << Endl;
        }

        return out;
    }
}
