#pragma once

#include "blackbox_client.h"

#include <library/cpp/tvmauth/type.h>

#include <util/generic/string.h>

namespace NPassport::NTvmknife::NBbProxy {
    class TCredential {
    public:
        TCredential(const TString& blackbox, const TString& userip = {});

        virtual ~TCredential() = default;

        virtual TString TryGetFromCache() const = 0;
        virtual void PutToCache(const TString& ticket) const = 0;
        virtual TBbClient::TRequest CreateRequest() const = 0;

        const TString& GetBlackbox() const {
            return Blackbox_;
        }

        TString GetUserIp() const;

    protected:
        const TString Blackbox_;
        const TString BlackboxTvmId_;

    private:
        const TString Userip_;
    };

    class TOAuthCredential: public TCredential {
    public:
        TOAuthCredential(const TString& blackbox, const TBbClient::TDebugUTParams& params);

        TString TryGetFromCache() const override;
        void PutToCache(const TString& ticket) const override;
        TBbClient::TRequest CreateRequest() const override;

    private:
        const TBbClient::TDebugUTParams Params_;
    };

    TString GetUserTicket(const TCredential& cred, TStringBuf serviceTicket);

    TString BbTvmId(const TString& blackbox);
    TString ListBlackboxes();
    std::vector<TString> SuggestBlackboxes();
    TString GetSelfIp();

    void AddBbTvmId(const TStringBuf blackbox);
}
