#pragma once

#include <library/cpp/openssl/crypto/sha.h>
#include <library/cpp/tvmauth/type.h>
#include <library/cpp/tvmknife/cache.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <set>

namespace NPassport::NTvmknife {
    class TCache: public ::NTvmknife::TCache {
    public:
        struct TUsrTick {
            static TUsrTick FromOAuth(const TString& bbTvmId,
                                      const TString& token,
                                      bool addScopeSessionId = false,
                                      bool addScopeSessguard = false) {
                TUsrTick res;

                NOpenSsl::NSha256::TDigest hash = NOpenSsl::NSha256::Calc(token);
                res.Token = TString((char*)hash.data(), hash.size());

                res.Ts = time(nullptr);
                res.BbTvmId = bbTvmId;

                res.AddScopeSessionId = addScopeSessionId;
                res.AddScopeSessguard = addScopeSessguard;

                return res;
            }

            TString Token;
            TString BbTvmId;

            bool AddScopeSessionId = false;
            bool AddScopeSessguard = false;

            TString Body;
            time_t Ts = 0;

            bool operator<(const TUsrTick& o) const {
                if (Token < o.Token) {
                    return true;
                }
                if (BbTvmId < o.BbTvmId) {
                    return true;
                }
                if (AddScopeSessionId < o.AddScopeSessionId) {
                    return true;
                }
                return AddScopeSessguard < o.AddScopeSessguard;
            }
        };

    public:
        TCache(); // only for tests

        static TCache& Get();

        TString GetPublicKeys();
        void SetPublicKeys(const TString& keys);

        TString GetUsrTicket(const TUsrTick& t);
        void SetUserTicket(TUsrTick&& t, const TString& body);

        static TString SerializeUsrTickets(const std::set<TUsrTick>& ticks);
        static std::set<TUsrTick> ParseUsrTickets(const TString& ticks);

        void SetCacheDir(const TString& dir);

        TString GetPublicKeysPath();
        TString GetUserTicketsPath();

        void Reset();

    private:
        void WriteUsrTicket(const TUsrTick& t);

    private:
        TString PublicKeys_;
        std::set<TUsrTick> UsrTickets_;
    };
}
