#include "get_ticket.h"

#include "tvm_client.h"

#include <passport/infra/libs/cpp/json/reader.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/tvmknife/simple_tvm_client.h>

#include <util/stream/str.h>
#include <util/string/cast.h>

namespace {
    class TSimpleClientUtils: NTvmknife::TSimpleTvmClient {
    public:
        using TSimpleTvmClient::GetTicketFromResponse;
        using TSimpleTvmClient::PrettifyJson;
    };
}

namespace NPassport::NTvmknife {
    TString TServiceTicket::GetTicketFromResponse(const TString& response, const TString& dst) {
        try {
            ::NJson::TJsonValue doc;
            Y_ENSURE(::NJson::ReadJsonTree(response, &doc));
            ::NJson::TJsonValue value;
            Y_ENSURE(doc.GetValue(dst, &value));
            Y_ENSURE(value.IsMap());

            Y_ENSURE(!value.Has("error"));

            ::NJson::TJsonValue ticket;
            Y_ENSURE(value.GetValue("ticket", &ticket));
            Y_ENSURE(ticket.IsString());
            return ticket.GetString();
        } catch (const std::exception& e) {
            ythrow yexception() << "Failed to get ticket from TVM response: " << e.what() << Endl
                                << response << Endl;
        }
    }

    TString TServiceTicket::GetTicketViaClientCred(const ui32 src,
                                                   const ui32 dst,
                                                   TStringBuf secret) {
        return TSimpleClientUtils::GetTicketFromResponse(
            TTvmClient::ClientCredentials(ToString(src), ToString(dst), secret),
            dst);
    }

    TString TUserTicket::GetTicketFromResponse(const TString& response) {
        try {
            rapidjson::Document doc;
            Y_ENSURE(NJson::TReader::DocumentAsObject(response, doc));

            TString res;
            Y_ENSURE(NJson::TReader::MemberAsString(doc, "user_ticket", res));

            Y_ENSURE(res, "user_ticket is empty");

            return res;
        } catch (const std::exception& e) {
            ythrow yexception() << "Failed to get user ticket from blackbox response: " << e.what() << Endl
                                << TSimpleClientUtils::PrettifyJson(response) << Endl;
        }
    }
}
