#pragma once

#include <library/cpp/tvmauth/type.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <optional>

namespace NPassport::NTvmknife {
    class TInfo {
    public:
        struct TTvmInfo {
            TString Description;
            ui64 AbcId = 0;
            std::optional<TInstant> DeletedAt;
            TString VaultLink;
            ui64 CreatorUid = 0;
        };
        static TTvmInfo GetInfoFromTvmResponse(const TString& response);

        enum class EColored {
            True,
            False,
        };

        struct TAdd {
            bool Yav = false;
            bool Creator = false;
        };

        static TString GetInfoImpl(const TString& id,
                                   const TTvmInfo& tvmInfo,
                                   TAdd add,
                                   EColored colored = EColored::True);

        static TString GetInfo(const TString& id, TAdd add);
    };
}
