#pragma once

#include <library/cpp/getopt/small/last_getopt.h>
#include <library/cpp/getopt/small/modchooser.h>

namespace NPassport::NTvmknife::NBbProxy {
    class TCredential;
}

namespace NPassport::NTvmknife {
    struct TConfidentialValue {
        TConfidentialValue(NLastGetopt::TOpts& opts,
                           char shortKey,
                           const TString& longKey,
                           const TString& help);

        bool IsDefault() const;
        const TString& Get();

        static TString ReadFromFile(const TString& path);
        static TString ReadFromStdin(const TString& longKey);

    private:
        TString ReadValue() const;

        static bool IsStdinEmpty();
        static TString ReadFromStdinImpl();

    private:
        TString Path_;
        TString Value_;
        TString LongKey_;
    };

    class TModeParse: public TMainClassArgs {
    public:
        void RegisterOptions(NLastGetopt::TOpts& opts) override;
        int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

    private:
        bool Unittest_ = false;
    };

    class TModeParseKeys: public TMainClassArgs {
    public:
        void RegisterOptions(NLastGetopt::TOpts& opts) override;
        int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;
    };

    class TModeServiceTicket: public TMainClassModes {
    public:
        class TModeClCred: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            std::unique_ptr<TConfidentialValue> Secret_;
            ui32 Src_ = 0;
            ui32 Dst_ = 0;
        };

        class TModeSshKey: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            TString Login_;
            TString Key_;
            TString CliSrc_;
            TString CliDst_;
        };

        TModeServiceTicket();

        void RegisterModes(TModChooser& modes) override;

    private:
        std::unique_ptr<TModeClCred> ModeClCred_;
        std::unique_ptr<TModeSshKey> ModeSshkey_;
    };

    class TModeUserTicket: public TMainClassModes {
    public:
        class TCommonOpts {
        public:
            TCommonOpts(NLastGetopt::TOpts& opts, bool addBlackbox = true);

            void FixBlackbox(const TString& override = {});
            TString GetServiceTicket() const;
            TString GetUserTicket(const NBbProxy::TCredential& cred) const;

            TString GetLogin() const;

        public:
            ui32 Src = 0;
            std::unique_ptr<TConfidentialValue> TvmSecret;
            TString Login;

            TString Blackbox;
        };

        class TModeOAuth: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            std::unique_ptr<TCommonOpts> CommonOpts_;

            std::unique_ptr<TConfidentialValue> Token_;
            bool AddScopeSessionid_ = false;
            bool AddScopeSessguard_ = false;
        };

        class TModeSshkey: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            std::unique_ptr<TCommonOpts> CommonOpts_;

            bool AddScopeSessionid_ = false;
            bool AddScopeSessguard_ = false;
            TString OauthClientId_;
            TString OauthClientSecret_;
        };

        class TModeListBlackboxes: public TMainClassArgs {
        public:
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;
        };

        TModeUserTicket();

        void RegisterModes(TModChooser& modes) override;

    private:
        std::unique_ptr<TModeOAuth> ModeOAuth_;
        std::unique_ptr<TModeSshkey> ModeSshkey_;
        std::unique_ptr<TModeListBlackboxes> ModeListBlackboxes_;
    };

    class TModeUnittest: public TMainClassModes {
    public:
        class TModeService: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            ui32 Src_ = 0;
            ui32 Dst_ = 0;
            TString Scopes_;
            ui32 IssuerUid_ = 0;
        };

        class TModeUser: public TMainClassArgs {
        public:
            void RegisterOptions(NLastGetopt::TOpts& opts) override;
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

        private:
            ui64 DefaultUid_ = 0;
            TString UidsStr_;
            TString Scopes_;
            TString Env_;
        };

        class TModeKeys: public TMainClassArgs {
        public:
            int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;
        };

        TModeUnittest();

        void RegisterModes(TModChooser& modes) override;

    private:
        std::unique_ptr<TModeService> ModeService_;
        std::unique_ptr<TModeUser> ModeUser_;
        std::unique_ptr<TModeKeys> ModeKeys_;
    };

    class TModeInfo: public TMainClassArgs {
    public:
        void RegisterOptions(NLastGetopt::TOpts& opts) override;
        int DoRun(NLastGetopt::TOptsParseResult&& parsedOptions) override;

    private:
        bool AddSecretLink_ = false;
        bool AddCreator_ = false;
    };

    int Run(int argc, const char** argv);
}
