#include "oauth_clients.h"

#include <library/cpp/oauth/oauth.h>
#include <library/cpp/tvmknife/output.h>

#include <util/folder/dirut.h>
#include <util/stream/str.h>
#include <util/string/builder.h>
#include <util/system/fs.h>

#include <vector>

namespace NPassport::NTvmknife {
    const TString TOAuth::DEFAULT_YATEAM_CLIENT_ID = "6a6b2642d15e49e4b5720158bb67165a";
    const TString TOAuth::DEFAULT_YATEAM_CLIENT_SECRET = "c41aaea452d842a0b35b9d223d65839e";

    struct TOAuthEnv {
        TString Oauth;
        TString Clid;
        std::vector<TString> Blackbox;
    };

    static const std::vector<TOAuthEnv> INSTANCES = {
        {
            "oauth.yandex.ru",
            "be4044964e7243f4b6dd1b6785e78cd3",
            {
                "blackbox.yandex.net",
                "blackbox-mail.yandex.net",
                "blackbox-mimino.yandex.net",
                "blackbox-stress.yandex.net",
                "pass-stress-*.sezam.yandex.net",
            },
        },
        {
            "oauth.yandex-team.ru",
            TOAuth::DEFAULT_YATEAM_CLIENT_ID,
            {"blackbox.yandex-team.ru"},
        },
        {
            "oauth-test.yandex.ru",
            "ea9075942f674dcf89e479909836b771",
            {"blackbox-test.yandex.net"},
        },
        {
            "oauth-test.yandex-team.ru",
            "8f780812d20e4a6ca9cf33987b6048e7",
            {"blackbox-test.yandex-team.ru"},
        },
    };

    TString TOAuth::ListLinks() {
        TStringStream res;

        for (const TOAuthEnv& env : INSTANCES) {
            for (const TString& bb : env.Blackbox) {
                res << bb << Endl;
            }
            res
                << " -> https://" << env.Oauth
                << "/authorize?response_type=token&client_id=" << env.Clid
                << Endl << Endl;
        }

        res.Str().pop_back();

        return res.Str();
    }

    TString TOAuth::GetToken(const TParams& params) {
        TOauthTokenParams oauthParams(params.ClientId, params.ClientSecret);
        oauthParams.SetLogin(params.Login);

        return GetOauthToken(oauthParams);
    }
}
