#pragma once

#include <library/cpp/tvmauth/ticket_status.h>
#include <library/cpp/tvmauth/type.h>
#include <library/cpp/tvmauth/src/protos/ticket2.pb.h>
#include <library/cpp/tvmauth/src/protos/tvm_keys.pb.h>
#include <library/cpp/tvmauth/src/rw/keys.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NTvmknife {
    class TBaseResult {
    public:
        virtual ~TBaseResult() = default;
        virtual TString Print() = 0;

    protected:
        virtual void ParseTicket(const ticket2::Ticket& t) = 0;
        virtual TString CheckSign(TStringBuf tvmKeys, TStringBuf ticketFull, TStringBuf ticketStrip, TStringBuf sign) = 0;
        TString PrintBase();

        int Version_ = 3;
        time_t ExpireTime_ = 0;
        NTvmAuth::NRw::TKeyId KeyId_ = 0;

        enum class ESign {
            Ok,
            Broken,
            NoSign,
            MalformedKeys,
            MissingKeys
        } Sign_ = ESign::MissingKeys;

        bool IsSignOk_ = false;
        NTvmAuth::ETicketStatus IntegralCheck_ = NTvmAuth::ETicketStatus::SignBroken;

        friend class TAnywayParser;
    };

    class TServiceResult: public TBaseResult {
    public:
        TString Print() override;

    private:
        void ParseTicket(const ticket2::Ticket& t) override;
        TString CheckSign(TStringBuf tvmKeys, TStringBuf ticketFull, TStringBuf ticketStrip, TStringBuf sign) override;

        NTvmAuth::TTvmId Src_ = 0;
        NTvmAuth::TTvmId Dst_ = 0;
        NTvmAuth::TScopes Scopes_;
        NTvmAuth::TUid Issuer_ = 0;
    };

    class TUserResult: public TBaseResult {
    public:
        TString Print() override;

    private:
        void ParseTicket(const ticket2::Ticket& t) override;
        TString CheckSign(TStringBuf tvmKeys, TStringBuf ticketFull, TStringBuf ticketStrip, TStringBuf sign) override;

        NTvmAuth::TUids Uids_;
        NTvmAuth::TUid DefaultUid_ = 0;
        NTvmAuth::TScopes Scopes_;
        NTvmAuth::TTvmId EntryPoint_ = 0;
        tvm_keys::BbEnvType Env_ = tvm_keys::BbEnvType::Test;
    };

    class TAnywayParser {
    public:
        static TString ParseV3(TStringBuf ticket, TStringBuf tvmKeys = {});

    private:
        struct TStrings {
            TStringBuf Type;
            TStringBuf ForCheck;
            TString ProtoBin;
            TString SignBin;
        };

        static TStrings ParseStringsV3(TStringBuf body);
    };

    TString ParseAnyTicket(const TString& strTicket);
    TString ParseAnyTicketUnittest(const TString& strTicket);
}
